#include "h2009.h"
#include "panels.h"
static void LCD_power_on(__u32 sel);
static void LCD_power_off(__u32 sel);
static void LCD_bl_open(__u32 sel);
static void LCD_bl_close(__u32 sel);
static void LCD_panel_init(__u32 sel);
static void LCD_panel_exit(__u32 sel);
static void LCD_cfg_panel_info(panel_extend_para * info)
{
	__u32 i = 0, j=0;
	__u32 items;
	__u8 lcd_gamma_tbl[][2] =
	{
		//{input value, corrected value}
		{0, 0},
		{15, 15},
		{30, 30},
		{45, 45},
		{60, 60},
		{75, 75},
		{90, 90},
		{105, 105},
		{120, 120},
		{135, 135},
		{150, 150},
		{165, 165},
		{180, 180},
		{195, 195},
		{210, 210},
		{225, 225},
		{240, 240},
		{255, 255},
	};
	__u32 lcd_cmap_tbl[2][3][4] = {
		{
			{LCD_CMAP_G0,LCD_CMAP_B1,LCD_CMAP_G2,LCD_CMAP_B3},
			{LCD_CMAP_B0,LCD_CMAP_R1,LCD_CMAP_B2,LCD_CMAP_R3},
			{LCD_CMAP_R0,LCD_CMAP_G1,LCD_CMAP_R2,LCD_CMAP_G3},
		},
		{
			{LCD_CMAP_B3,LCD_CMAP_G2,LCD_CMAP_B1,LCD_CMAP_G0},
			{LCD_CMAP_R3,LCD_CMAP_B2,LCD_CMAP_R1,LCD_CMAP_B0},
			{LCD_CMAP_G3,LCD_CMAP_R2,LCD_CMAP_G1,LCD_CMAP_R0},
		},
	};
	items = sizeof(lcd_gamma_tbl)/2;
	for(i=0; i<items-1; i++) {
		__u32 num = lcd_gamma_tbl[i+1][0] - lcd_gamma_tbl[i][0];
		for(j=0; j<num; j++) {
			__u32 value = 0;
			value = lcd_gamma_tbl[i][1] + ((lcd_gamma_tbl[i+1][1] - lcd_gamma_tbl[i][1]) * j)/num;
			info->lcd_gamma_tbl[lcd_gamma_tbl[i][0] + j] = (value<<16) + (value<<8) + value;
		}
	}
	info->lcd_gamma_tbl[255] = (lcd_gamma_tbl[items-1][1]<<16) + (lcd_gamma_tbl[items-1][1]<<8) + lcd_gamma_tbl[items-1][1];
	memcpy(info->lcd_cmap_tbl, lcd_cmap_tbl, sizeof(lcd_cmap_tbl));
}
static __s32 LCD_open_flow(__u32 sel)
{
	LCD_OPEN_FUNC(sel, LCD_power_on, 30);   //open lcd power, and delay 30ms
	LCD_OPEN_FUNC(sel, LCD_panel_init, 10);   //open lcd power, than delay 10ms
	LCD_OPEN_FUNC(sel, sunxi_lcd_tcon_enable, 200);     //open lcd controller, and delay 200ms
	LCD_OPEN_FUNC(sel, LCD_bl_open, 0);     //open lcd backlight, and delay 0ms
	return 0;
}
static __s32 LCD_close_flow(__u32 sel)
{
	LCD_CLOSE_FUNC(sel, LCD_bl_close, 200);       //close lcd backlight, and delay 200ms
	LCD_CLOSE_FUNC(sel, sunxi_lcd_tcon_disable, 5);         //close lcd controller, and delay 5ms
	LCD_CLOSE_FUNC(sel, LCD_panel_exit,	20);   //open lcd power, than delay 20ms
	LCD_CLOSE_FUNC(sel, LCD_power_off, 50);   //close lcd power, and delay 50ms
	return 0;
}
static void LCD_power_on(__u32 sel)
{
	sunxi_lcd_power_enable(sel, 0);//config lcd_power pin to open lcd power0
	sunxi_lcd_power_enable(sel, 1);//config lcd_power pin to open lcd power1
	sunxi_lcd_power_enable(sel, 2);//config lcd_power pin to open lcd power2
}
static void LCD_power_off(__u32 sel)
{
	sunxi_lcd_pin_cfg(sel, 0);
	sunxi_lcd_power_disable(sel, 0);//config lcd_power pin to close lcd power0
	sunxi_lcd_power_disable(sel, 1);//config lcd_power pin to close lcd power1
	sunxi_lcd_power_disable(sel, 2);//config lcd_power pin to close lcd power2
}
static void LCD_bl_open(__u32 sel)
{
	sunxi_lcd_pwm_enable(sel);//open pwm module
	sunxi_lcd_backlight_enable(sel);//config lcd_bl_en pin to open lcd backlight
}
static void LCD_bl_close(__u32 sel)
{
	sunxi_lcd_backlight_disable(sel);//config lcd_bl_en pin to close lcd backlight
	sunxi_lcd_pwm_disable(sel);//close pwm module
}
#define REGFLAG_DELAY             							0X01
#define REGFLAG_END_OF_TABLE      						0x02   // END OF REGISTERS MARKER
struct LCM_setting_table {
	__u8 cmd;
	__u32 count;
	__u8 para_list[64];
};
static struct LCM_setting_table IVO2406_initialization_setting[] = {
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x13}},
	{0xEF,	0x01,	{0x08}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x10}},
	{0xC0,	0x02,	{0x63,0x00}},
	{0xC1,	0x02,	{0x0C,0x0A}},
	{0xC2,	0x02,	{0x07,0x0F}},
	{0xC7,	0x01,	{0x00}},
	{0xCC,	0x01,	{0x10}},
	{0xB0,	0x10,	{0x08,0x0C,0x16,0x09,0x0D,0x05,0x00,0x08,0x08,0x1C,0x04,0x12,0x10,0x26,0x2D,0x1F}},
	{0xB1,	0x10,	{0x0F,0x17,0x18,0x0E,0x10,0x05,0x01,0x08,0x08,0x1D,0x05,0x12,0x10,0x28,0x2F,0x1F}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x11}},
	{0xB0,	0x01,	{0x87}},
	{0xB1,	0x01,	{0x3A}},
	{0xB2,	0x01,	{0x80}},
	{0xB3,	0x01,	{0x80}},
	{0xB5,	0x01,	{0x40}},
	{0xB7,	0x01,	{0x85}},
	{0xB8,	0x01,	{0x21}},
	{0xB9,	0x02,	{0x01,0x1F}},
	{0xC1,	0x01,	{0x78}},
	{0xC2,	0x01,	{0x78}},
	{0xD0,	0x01,	{0x88}},
	{0xE0,	0x03,	{0x80,0x00,0x02}},
	{0xE1,	0x0B,	{0x04,0xA0,0x06,0xA0,0x05,0xA0,0x07,0xA0,0x00,0x44,0x44}},
	{0xE2,	0x0D,	{0x33,0x33,0x44,0x44,0x28,0xA0,0x2A,0xA0,0x29,0xA0,0x2B,0xA0,0x00}},
	{0xE3,	0x04,	{0x00,0x00,0x33,0x33}},
	{0xE4,	0x02,	{0x44,0x44}},
	{0xE5,	0x10,	{0x06,0x2A,0xA0,0xA0,0x08,0x2C,0xA0,0xA0,0x0A,0x2E,0xA0,0xA0,0x0C,0x30,0xA0,0xA0}},
	{0xE6,	0x04,	{0x00,0x00,0x33,0x33}},
	{0xE7,	0x02,	{0x44,0x44}},
	{0xE8,	0x10,	{0x07,0x2B,0xA0,0xA0,0x09,0x2D,0xA0,0xA0,0x0B,0x2F,0xA0,0xA0,0x0D,0x31,0xA0,0xA0}},
	{0xEB,	0x07,	{0x00,0x01,0x4E,0x4E,0xEE,0x44,0x00}},
	{0xED,	0x10,	{0xFF,0xF1,0x04,0x56,0x72,0x3F,0xFF,0xFF,0xFF,0xFF,0xF3,0x27,0x65,0x40,0x1F,0xFF}},
	{0xEF,	0x06,	{0x08,0x08,0x08,0x45,0x3F,0x54}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x13}},
	{0xE8,	0x02,	{0x00,0x0E}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x00}},
	{0x11,	0x00,	{}},
	{REGFLAG_DELAY, 120, {}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x13}},
	{0xE8,	0x02,	{0x00,0x0C}},
	{REGFLAG_DELAY, 10, {}},
	{0xE8,	0x02,	{0x00,0x00}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x00}},
	{0x29,	0x00,	{}},
	{0x35,	0x01,	{0x00}},
	{0x36,	0x01,	{0x00}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x12}},
	{0xD1,	0x01,	{0x00}},
	{0xD2,	0x01,	{0x06}},

	{0x11,	0x00,	{}},
	{REGFLAG_DELAY, 120, {}},
	{0x29,	0x00,	{}},
	{REGFLAG_DELAY, 20, {}},
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static struct LCM_setting_table BOE2412_initialization_setting[] = {
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x13}},
	{0xEF,	0x01,	{0x08}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x10}},
	{0xC0,	0x02,	{0x63,0x00}},
	{0xC1,	0x02,	{0x0A,0x02}},
	{0xC2,	0x02,	{0x07,0x08}},
	{0xCC,	0x01,	{0x10}},
	{0xB0,	0x10,	{0x00,0x11,0x19,0x0C,0x10,0x06,0x07,0x0A,0x09,0x22,0x04,0x10,0x0E,0x28,0x30,0x1C}},
	{0xB1,	0x10,	{0x00,0x12,0x19,0x0D,0x10,0x04,0x06,0x07,0x08,0x23,0x04,0x12,0x11,0x28,0x30,0x1C}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x11}},
	{0xB0,	0x01,	{0x4D}},
	{0xB1,	0x01,	{0x3c}},
	{0xB2,	0x01,	{0x07}},
	{0xB3,	0x01,	{0x80}},
	{0xB5,	0x01,	{0x47}},
	{0xB7,	0x01,	{0x85}},
	{0xB8,	0x01,	{0x21}},
	{0xB9,	0x01,	{0x10}},
	{0xC1,	0x01,	{0x78}},
	{0xC2,	0x01,	{0x78}},
	{0xD0,	0x01,	{0x88}},
	{0xE0,	0x03,	{0x00,0x00,0x02}},
	{0xE1,	0x0C,	{0x04,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x00,0x20,0x20}},
	{0xE2,	0x0E,	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0xE3,	0x04,	{0x00,0x00,0x33,0x00}},
	{0xE4,	0x02,	{0x22,0x00}},
	{0xE5,	0x10,	{0x04,0x34,0xAA,0xAA,0x06,0x34,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0xE6,	0x04,	{0x00,0x00,0x33,0x00}},
	{0xE7,	0x02,	{0x22,0x00}},
	{0xE8,	0x10,	{0x05,0x34,0xAA,0xAA,0x07,0x34,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0xEB,	0x07,	{0x02,0x00,0x40,0x40,0x00,0x00,0x00}},
	{0xEC,	0x02,	{0x00,0x00}},
	{0xED,	0x10,	{0xFA,0x45,0x0B,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xB0,0x54,0xAF}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x00}},
	{0x36,	0x01,	{0x00}},
	
	{0x11,	0,	{}},
	{REGFLAG_DELAY, 120, {}},
	{0x29,	0,	{}},
	{REGFLAG_DELAY, 20, {}},
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static struct LCM_setting_table h2009_initialization_setting[] = {
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x13}},
	{0xEF,	0x01,	{0x08}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x10}},
	{0xC0,	0x02,	{0x63,0x00}},
	{0xC1,	0x02,	{0x10,0x02}},
	{0xC2,	0x02,	{0x01,0x08}},
	{0xCC,	0x01,	{0x38}},
	{0xB0,	0x10,	{0x40,0xc9,0x90,0x0d,0x0f,0x04,0x00,0x07,0x07,0x1c,0x04,0x52,0x0f,0xdf,0x26,0xcf}},
	{0xB1,	0x10,	{0x40,0xc9,0xcf,0x0c,0x90,0x04,0x00,0x07,0x08,0x1b,0x06,0x55,0x13,0x62,0xe7,0xcf}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x11}},
	{0xB0,	0x01,	{0x5D}},
	{0xB1,	0x01,	{0x2D}},
	{0xB2,	0x01,	{0x07}},
	{0xB3,	0x01,	{0x80}},
	{0xB5,	0x01,	{0x08}},
	{0xB7,	0x01,	{0x85}},
	{0xB8,	0x01,	{0x20}},
	{0xB9,	0x01,	{0x10}},
	{0xC1,	0x01,	{0x78}},
	{0xC2,	0x01,	{0x78}},
	{0xD0,	0x01,	{0x88}},
	{0xE0,	0x03,	{0x00,0x19,0x02}},
	{0xE1,	0x0B,	{0x05,0xa0,0x07,0xa0,0x04,0xa0,0x06,0xa0,0x00,0x44,0x44}},
	{0xE2,	0x0C,	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	{0xE3,	0x04,	{0x00,0x00,0x33,0x33}},
	{0xE4,	0x02,	{0x44,0x44}},
	{0xE5,	0x10,	{0x0d,0x31,0xc8,0xaf,0x0f,0x33,0xc8,0xaf,0x09,0x2d,0xc8,0xaf,0x0b,0x2f,0xc8,0xaf}},
	{0xE6,	0x04,	{0x00,0x00,0x33,0x33}},
	{0xE7,	0x02,	{0x44,0x44}},
	{0xE8,	0x10,	{0x0c,0x30,0xc8,0xaf,0x0e,0x32,0xc8,0xaf,0x08,0x2c,0xc8,0xaf,0x0a,0x2e,0xc8,0xaf}},
	{0xEB,	0x07,	{0x02,0x00,0xe4,0xe4,0x44,0x00,0x40}},
	{0xEC,	0x02,	{0x3C,0x00}},
	{0xED,	0x10,	{0xab,0x89,0x76,0x54,0x01,0xff,0xff,0xff,0xff,0xff,0xff,0x10,0x45,0x67,0x98,0xba}},
	{0xEF,	0x0B,	{0x08,0x08,0x08,0x45,0x3f,0x54,0x77,0x01,0x00,0x00,0x00}},
	{0xFF,	0x05,	{0x77,0x01,0x00,0x00,0x00}},

	{0x11,	0x01,	{0x00}},
	{REGFLAG_DELAY, 0x78, {}},
	{0x29,	0x01,	{0x00}},
	{REGFLAG_DELAY, 0x14, {}},
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static void LCD_panel_init(__u32 sel)
{
	__u32 i;
	__u32 rx_num;
	__u8 rx_bf;
	__u32 IVO2406_used = 0;
	__u32 BOE2412_used = 0;

	sunxi_lcd_pin_cfg(sel, 1);
	sunxi_lcd_delay_ms(10);

	panel_rst(1);
	sunxi_lcd_delay_ms(10);
	panel_rst(0);
	sunxi_lcd_delay_ms(10);
	panel_rst(1);
	sunxi_lcd_delay_ms(120);


	dsi_dcs_rd(0, 0x04, &rx_bf, &rx_num);
	if ( rx_bf == 0x50 )
		IVO2406_used = 1;
	else if ( rx_bf == 0x30 )
		BOE2412_used = 1;

	if( IVO2406_used )//used IVO2406
	{
		for (i=0;;i++) {
			if(IVO2406_initialization_setting[i].cmd == 0x02)
				break;
			else if (IVO2406_initialization_setting[i].cmd == 0x01)
				sunxi_lcd_delay_ms(IVO2406_initialization_setting[i].count);
			else
				dsi_dcs_wr(0,IVO2406_initialization_setting[i].cmd,IVO2406_initialization_setting[i].para_list,IVO2406_initialization_setting[i].count);
		}
	} else if ( BOE2412_used ) {//uses BOE2412
		for (i=0;;i++) {
			if(BOE2412_initialization_setting[i].cmd == 0x02)
				break;
			else if (BOE2412_initialization_setting[i].cmd == 0x01)
				sunxi_lcd_delay_ms(BOE2412_initialization_setting[i].count);
			else
				dsi_dcs_wr(0,BOE2412_initialization_setting[i].cmd,BOE2412_initialization_setting[i].para_list,BOE2412_initialization_setting[i].count);
		}
	} else {//used h2009
		for (i=0;;i++) {
			if(h2009_initialization_setting[i].cmd == 0x02)
				break;
			else if (h2009_initialization_setting[i].cmd == 0x01)
				sunxi_lcd_delay_ms(h2009_initialization_setting[i].count);
			else
				dsi_dcs_wr(0,h2009_initialization_setting[i].cmd,h2009_initialization_setting[i].para_list,h2009_initialization_setting[i].count);
		}
	}

	sunxi_lcd_dsi_clk_enable(sel);
	return;
}
static void LCD_panel_exit(__u32 sel)
{
	sunxi_lcd_dsi_clk_disable(sel);
	dsi_dcs_wr(0,0x28,0,0);
	sunxi_lcd_delay_ms(80);
	dsi_dcs_wr(0,0x10,0,0);
	sunxi_lcd_delay_ms(5);
	return ;
}
//sel: 0:lcd0; 1:lcd1
static __s32 LCD_user_defined_func(__u32 sel, __u32 para1, __u32 para2, __u32 para3)
{
	return 0;
}
__lcd_panel_t h2009_panel = {
	/* panel driver name, must mach the name of lcd_drv_name in sys_config.fex */
	.name = "h2009",
	.func = {
		.cfg_panel_info = LCD_cfg_panel_info,
		.cfg_open_flow = LCD_open_flow,
		.cfg_close_flow = LCD_close_flow,
		.lcd_user_defined_func = LCD_user_defined_func,
	},
};
